<?php
// =====================
// 🔧 Konfigurasi Database
// =====================
$host     = 'localhost';         // Ganti dengan IP jika pakai jaringan: contoh '10.168.177.138'
$dbname   = 'absensipkl';        // Nama database kamu (harus sama dengan di phpMyAdmin)
$username = 'root';              // Username database (default XAMPP)
$password = '';                  // Kosongkan jika belum diset

$charset  = 'utf8mb4';           // Gunakan utf8mb4 agar mendukung emoji & karakter internasional

// =====================
// 🧩 DSN dan Opsi PDO
// =====================
$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";

$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // Tampilkan error dengan exception
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // Ambil data dalam bentuk array asosiatif
    PDO::ATTR_EMULATE_PREPARES   => false,                  // Gunakan native prepared statements (lebih aman)
];

// =====================
// 🚀 Koneksi PDO ke MySQL
// =====================
try {
    $pdo = new PDO($dsn, $username, $password, $options);
} catch (PDOException $e) {
    // Jika gagal, kirim respons JSON error
    echo json_encode([
        'success' => false,
        'msg'     => '❌ Gagal koneksi ke database: ' . $e->getMessage()
    ]);
    exit;
}
?>
